<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */

    include "../../include/includeBaseControllerComponenti.php";
    include "../classi/VisualizzatoreRisorsa.php";
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $visualizzatore = new VisualizzatoreRisorsa($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $visualizzatore = new VisualizzatoreRisorsa($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    switch ($operazione) {
        case 'crea':
            $visualizzatore->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $visualizzatore->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_STRING));
            $visualizzatore->setCategoria(filter_input(INPUT_POST,"categoria",FILTER_SANITIZE_NUMBER_INT));
            $visualizzatore->setClasseElementi(filter_input(INPUT_POST,"classeElementi",FILTER_SANITIZE_STRING));
            $visualizzatore->setFiltrabile(filter_input(INPUT_POST,"classeElemento",FILTER_SANITIZE_STRING));
            $visualizzatore->setFiltrabile(filter_input(INPUT_POST,"filtrabile",FILTER_SANITIZE_STRING));
            $visualizzatore->setATuttaLarghezza(filter_input(INPUT_POST,"aTuttaLarghezza",FILTER_SANITIZE_STRING));
            $visualizzatore->setSenzaBordi(filter_input(INPUT_POST,"senzaBordi",FILTER_SANITIZE_STRING));
            $visualizzatore->crea();
            header("Location: ../creaVisualizzatoreRisorse.php?id={$visualizzatore->getId()}&status=200");
            break;
        case 'modifica':
            $visualizzatore->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $visualizzatore->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_STRING));
            $visualizzatore->setCategoria(filter_input(INPUT_POST,"categoria",FILTER_SANITIZE_NUMBER_INT));
            $visualizzatore->setClasseElementi(filter_input(INPUT_POST,"classeElementi",FILTER_SANITIZE_STRING));
            $visualizzatore->setFiltrabile(filter_input(INPUT_POST,"classeElemento",FILTER_SANITIZE_STRING));
            $visualizzatore->setFiltrabile(filter_input(INPUT_POST,"filtrabile",FILTER_SANITIZE_STRING));
            $visualizzatore->setATuttaLarghezza(filter_input(INPUT_POST,"aTuttaLarghezza",FILTER_SANITIZE_STRING));
            $visualizzatore->setSenzaBordi(filter_input(INPUT_POST,"senzaBordi",FILTER_SANITIZE_STRING));
            $visualizzatore->modifica();
            header("Location: ../creaVisualizzatoreRisorse.php?id={$visualizzatore->getId()}&status=250");
            break;
        case 'elimina':
            $visualizzatore->elimina();
            echo "ok";
            break;
        case 'duplica':
            $visualizzatore->caricaDatiDalDatabase();
            $idNuovoVisualizzatore = $visualizzatore->duplica();
            header("Location: ../creaVisualizzatoreRisorse.php?id={$idNuovoVisualizzatore}&status=260");
            break;
    }
